variable "token" {
    description = "The Linode API Personal Access Token."
}

variable "ssh_keys" {
    description = "A list of SSH keys to use for connecting to the instances."
}

variable "root_password" {
    description = "The root password created for the Linode instances."
}

variable "region" {
    description = "The Linode region for the instances."
    default = "us-southeast"
}

variable "linode_image" {
    description = "The Linode image to use for the instances."
    default = "linode/ubuntu20.04"
}

variable "server_count" {
    description = "The number of Nomad/Consul server instances to create."
    default = 3
}

variable "client_count" {
    description = "The number of Nomad/Consul client instances to create."
    default = 3
}

variable "server_type" {
    description = "The type of Linode Compute instance to deploy for the server instances."
    default = "g6-dedicated-2"
}

variable "client_type" {
    description = "The type of Linode Compute instance to deploy for the client instances."
    default = "g6-standard-2"
}

